global MAX_LOADVERTS 	= 2048
global MAX_LOADFACES		= 3072
global MAX_LOADOBJECTS	= 32
global MAX_FRAMES   	= 2048
global MAX_OBJECT_NAMES = 32
global MAX_MATERIALS    = 256
global MAX_BLENDBONES   = 8
global MAX_BONES        = 256

struct loadbone
(
	parent = -1,
	type = 0, -- used to define a (legbone = 1)
	offset, --[ 3 ]
	matrix  --[ 3 ][ 3 ]
)

struct blendvert
(
	bone = 0,
	offset, --[ 3 ]
	weight = 0.0
)

struct loadvertex
(
	numbones = 0,
	blend = #(), -- blendvert blend[ 8 ]
	normal -- float normal[ 3 ]
)

struct loadfacevertex
(
	vertindex = 0 ,
	s = 0.0,
	t = 0.0
)
	
struct loadtriangle
(
	id = 0,
	verts = #() --loadfacevertex[ 3 ]
)

struct loadobject
(
	name,
	startvert = 0,
	startface = 0,
	numverts = 0,
	numfaces = 0
)

struct loadsingle
(
	name,
	numverts = 0,
	numfaces = 0,
	numobjects = 0,
	nummaterials = 1,
	hasmapping = 0,
	objects = #(), --loadobject objects[ 32 ]
	faces = #(), --loadtriangle faces[ 3072 ]
	verts = #(), --loadvertex verts[ 2048 ]
	materials = #(), --int materials [ 256 ]
	materialnames = #(),
	usedbone = #(), -- bool usedbone[ 256 ]
	numusedbone = 0
)

struct loadframe
(
	bones = #()--loadbone bones[ 256 ]
)
	
	